// Display version
const manifest = chrome.runtime.getManifest();
document.getElementById('version').textContent = `v${manifest.version}`;

// Load saved caller name on popup open
chrome.storage.sync.get(['callerName'], function(result) {
  const callerName = result.callerName || 'Mario'; // Default to Mario

  // Set the radio button
  const radio = document.getElementById(callerName.toLowerCase());
  if (radio) {
    radio.checked = true;
    // Add selected class to the option
    const option = document.querySelector(`.caller-option[data-caller="${callerName}"]`);
    if (option) {
      option.classList.add('selected');
    }
  }
});

// Handle caller option clicks
document.querySelectorAll('.caller-option').forEach(option => {
  option.addEventListener('click', function() {
    const callerName = this.dataset.caller;
    const radio = this.querySelector('input[type="radio"]');
    radio.checked = true;

    // Update selected class
    document.querySelectorAll('.caller-option').forEach(opt => {
      opt.classList.remove('selected');
    });
    this.classList.add('selected');

    // Save to chrome.storage
    chrome.storage.sync.set({ callerName: callerName }, function() {
      // Show success message
      const status = document.getElementById('status');
      status.textContent = `Caller set to ${callerName}`;
      status.className = 'status success show';

      // Send message to content script to update localStorage
      chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        if (tabs[0]) {
          chrome.tabs.sendMessage(tabs[0].id, {
            type: 'UPDATE_CALLER_NAME',
            callerName: callerName
          }).catch(err => {
            // Ignore errors if content script isn't loaded
            console.log('Could not send message to content script:', err);
          });
        }
      });

      setTimeout(() => {
        status.classList.remove('show');
      }, 2000);
    });
  });
});

// Handle radio button changes directly
document.querySelectorAll('input[type="radio"]').forEach(radio => {
  radio.addEventListener('change', function() {
    if (this.checked) {
      // Trigger the parent click handler
      this.closest('.caller-option').click();
    }
  });
});
