# Close.com Lead Source Extension

Chrome extension that color-codes leads by source and displays lead source badges on Close.com.

## Features

- Intercepts API calls to `/api/v1/lead/lead_*` endpoints
- Extracts and caches "Lead Source" custom field from lead data
- Color-codes page background based on lead source
- Adds lead source badges to:
  - Lead header
  - Active call bar

## Installation

1. **Add Extension Icons** (required):
   - Add the following icon files to the `icons/` directory:
     - `icon16.png` (16x16 pixels)
     - `icon48.png` (48x48 pixels)
     - `icon128.png` (128x128 pixels)
   - You can create simple colored squares or use your own icons

2. **Load Extension in Chrome**:
   - Open Chrome and navigate to `chrome://extensions/`
   - Enable "Developer mode" (toggle in top right)
   - Click "Load unpacked"
   - Select the `/home/fipso/code/far/extension` directory
   - The extension should now appear in your extensions list

3. **Verify Installation**:
   - Navigate to any lead page on `https://app.close.com/lead/*`
   - Open Developer Console (F12)
   - Look for `[Lead Source Extension] Extension loaded` message
   - The page background should be color-coded and badges should appear

## Lead Source Colors

| Lead Source | Background Color |
|------------|-----------------|
| C-Level Liste | #E8F5E9 (Light Green) |
| Digitalisierungshilfe | #E3F2FD (Light Blue) |
| Meta Ads Liste | #FFF3E0 (Light Orange) |
| Other | #F5F5F5 (Light Gray) |
| Provipanda | #FCE4EC (Light Pink) |
| Startups Liste | #F3E5F5 (Light Purple) |
| Default | #FAFAFA (Off White) |

## How It Works

1. **Fetch Interception**: Hooks into `window.fetch` to intercept API calls containing `lead_` prefix
2. **Data Extraction**: Parses API responses to extract the "Lead Source" custom field
3. **Caching**: Stores lead sources in memory to avoid repeated API calls
4. **DOM Manipulation**: Applies background colors and inserts badges into the page
5. **URL Monitoring**: Detects navigation to new leads and updates accordingly

## Files

- `manifest.json` - Extension configuration and permissions
- `content.js` - Main content script with fetch interception and DOM manipulation
- `icons/` - Extension icons (you need to add these)

## Debugging

Open Chrome DevTools Console (F12) to see detailed logs:
- API call interceptions
- Lead source caching
- Badge application
- Background color changes
