// Bridge script runs in ISOLATED world and has access to Chrome APIs
// It forwards messages between the popup and the MAIN world content script

// Listen for messages from popup
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.type === 'UPDATE_CALLER_NAME') {
    // Forward to MAIN world via window.postMessage
    window.postMessage({
      type: 'CALLER_NAME_UPDATE',
      callerName: message.callerName,
      source: 'close-extension-bridge'
    }, '*');
  }
  return true;
});

// Load initial caller name from storage and send to page
chrome.storage.sync.get(['callerName'], function(result) {
  const callerName = result.callerName || 'Mario';
  window.postMessage({
    type: 'CALLER_NAME_INIT',
    callerName: callerName,
    source: 'close-extension-bridge'
  }, '*');
});

// Version update checking via background service worker
const manifest = chrome.runtime.getManifest();
const currentVersion = manifest.version;

// Send current version to page
window.postMessage({
  type: 'EXTENSION_VERSION',
  version: currentVersion,
  source: 'close-extension-bridge'
}, '*');

// Check for updates via background script (bypasses CORS)
chrome.runtime.sendMessage(
  { type: 'CHECK_FOR_UPDATES', currentVersion },
  (response) => {
    if (response && response.updateAvailable) {
      console.log('[Close Extension Bridge] Update available:', response.latestVersion, '(current:', currentVersion + ')');
      window.postMessage({
        type: 'UPDATE_AVAILABLE',
        currentVersion: currentVersion,
        latestVersion: response.latestVersion,
        downloadUrl: response.downloadUrl,
        source: 'close-extension-bridge'
      }, '*');
    } else {
      console.log('[Close Extension Bridge] Up to date:', currentVersion);
    }
  }
);
